`varianceDecomposition` <-
function (obj) 
{
    if (!exists("effectsNames")) {
        effectsNames <- NULL
        rm(effectsNames)
        data(effectsNames, package = "noia")
    }
    ans <- list()
    if (class(obj) == "noia.linear" || class(obj) == "noia.multilinear") {
        n <- names(obj$variances)
        if (obj$nloc == 1) {
            n.a <- c(0, 1, 0)
            n.d <- c(0, 0, 1)
            n.e <- c(0, 0, 0)
        }
        else {
            n.a <- apply(sapply(strsplit(n, ""), "c") == effectsNames[2], 
                2, "sum")
            n.d <- apply(sapply(strsplit(n, ""), "c") == effectsNames[3], 
                2, "sum")
            n.e <- apply(sapply(strsplit(n, ""), "c") == effectsNames[4], 
                2, "sum")
        }
        cat("\n")
        for (lev in 1:(obj$nloc)) {
            if (class(obj) == "noia.linear" || lev < 2) {
                for (nr.d in 0:lev) {
                  nr.a <- lev - nr.d
                  v <- sum(obj$variances[(n.a == nr.a) & (n.d == 
                    nr.d)])
                  if (is.na(v)) {
                    v <- 0
                  }
                  if (v > 0) {
                    order.label <- as.character(lev)
                    component.label <- paste(rep("A", nr.a), 
                      rep("D", nr.d), sep = "", collapse = "")
                    names(v) <- component.label
                    ans[[order.label]] <- c(ans[[order.label]], 
                      v)
                  }
                }
            }
            else {
                v <- sum(obj$variances[n.e == lev])
                if (is.na(v)) {
                  v <- 0
                }
                if (v > 0) {
                  order.label <- as.character(lev)
                  component.label <- paste(rep("E", lev), sep = "", 
                    collapse = "")
                  names(v) <- component.label
                  ans[[order.label]] <- c(ans[[order.label]], 
                    v)
                }
            }
        }
    }
    else {
        stop("Class", class(obj), "unknown.\n")
    }
    class(ans) <- c("noia.vardec", class(ans))
    return(ans)
}
