% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_linked.R
\name{sim_linked}
\alias{sim_linked}
\title{simulate a sequence assuming conditional substitutions on the node.}
\usage{
sim_linked(
  phy,
  Q = rep(1, 6),
  rate = 0.1,
  node_mut_rate_double = 1e-09,
  l = 1000,
  bf = rep(0.25, 4),
  rootseq = NULL,
  node_time = 0.01
)
}
\arguments{
\item{phy}{tree for which to simulate sequences}

\item{Q}{substitution matrix along the branches, default = JC}

\item{rate}{mutation rate , default = 1}

\item{node_mut_rate_double}{mutation rate on the node, default = 1e-9}

\item{l}{number of base pairs to simulate}

\item{bf}{base frequencies, default = c(0.25, 0.25, 0.25, 0.25)}

\item{rootseq}{sequence at the root, simulated by default}

\item{node_time}{time spent at the node}
}
\value{
list with four items \enumerate{
\item{alignment} Phydat object with the resulting alignment
\item{rootseq} the rootsequence used
\item{total_branch_substitutions} total number of substitutions accumulated
on the branches
\item{total_node_substitutions} total number of substitutions accumulated at
the nodes}
}
\description{
simulate a sequence assuming conditional substitutions on the node.
}
