% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table.R
\docType{methods}
\name{sqlData}
\alias{sqlData}
\alias{sqlData,AthenaConnection-method}
\title{Converts data frame into suitable format to be uploaded to Athena}
\usage{
\S4method{sqlData}{AthenaConnection}(con, value, row.names = NA,
  file.type = c("tsv", "csv", "parquet"), ...)
}
\arguments{
\item{con}{A database connection.}

\item{value}{A data frame}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{file.type}{What file type to store data.frame on s3, noctua currently supports ["csv", "tsv", "parquet"].
\strong{Note:} This parameter is used for format any special characters that clash with file type separator.}

\item{...}{Other arguments used by individual methods.}
}
\value{
\code{sqlData} returns a dataframe formatted for Athena. Currently converts \code{list} variable types into \code{character}
        split by \code{'|'}, similar to how \code{data.table} writes out to files.
}
\description{
This method converts data.frame columns into the correct format so that it can be uploaded Athena.
}
\seealso{
\code{\link[DBI]{sqlData}}
}
