% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funs.cell.spec.ss}
\alias{funs.cell.spec.ss}
\alias{cell.spec.ss.ct}
\alias{cell.spec.ss}
\title{Pielou's Cell-specific Segregation Test with Normal Approximation (for Sparse Sampling)}
\usage{
cell.spec.ss.ct(
  ct,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

cell.spec.ss(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{cell.spec.ss.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the entries, \eqn{N_{ij}} in the NNCT}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{cell.spec.ss} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{cell.spec.ss} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{cell.spec.ss} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of \eqn{Z} test statistics for cell-specific tests}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values for the hypothesis test for the corresponding alternative}
\item{LCL,UCL}{Matrix of Lower and Upper Confidence Levels for the entries \eqn{N_{ij}} in the NNCT 
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{conf.int}{The confidence interval for the estimates, it is \code{NULL} here, since we provide the \code{UCL} and \code{LCL}
in \code{matrix} form.}
\item{cnf.lvl}{Level of the upper and lower confidence limits (i.e., conf.level) of the NNCT entries.}
\item{estimate}{Estimates of the parameters, i.e., matrix of the NNCT entries of the \eqn{k \times k} NNCT, Nij
for i,j=1,2,\ldots,k.}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null value for the expected values of the NNCT entries, 
E(Nij) for i,j=1,2,\ldots,k.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{cell.spec.ss.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{cell.spec.ss} only}
}
\description{
Two functions: \code{cell.spec.ss.ct} and \code{cell.spec.ss}.

Both functions are objects of class \code{"cellhtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected values of the 
cell counts (i.e., entries) in the NNCT for \eqn{k \ge 2} classes.
Each test is appropriate (i.e. have the appropriate asymptotic sampling distribution)
when that data is obtained by sparse sampling.

Each cell-specific segregation test is based on the normal approximation of the entries
in the NNCT and are due to \insertCite{pielou:1961;textual}{nnspat}.

Each function yields a contingency table of the test statistics, \eqn{p}-values for the corresponding 
alternative, expected values, lower and upper confidence levels, sample estimates (i.e. observed values)
and null value(s) (i.e. expected values) for the \eqn{N_{ij}} values for \eqn{i,j=1,2,\ldots,k} and also names of the test
statistics, estimates, null values and the method and the data set used.

The null hypothesis is that all \eqn{E(N_{ij})=n_i c_j /n} where \eqn{n_i} is the sum of row \eqn{i} (i.e. size of class \eqn{i})
\eqn{c_j} is the sum of column \eqn{j} in the \eqn{k \times k} NNCT for \eqn{k \ge 2}.
In the output, the test statistic, \eqn{p}-value and the lower and upper confidence limits are valid only 
for (properly) sparsely sampled data.

See also
(\insertCite{pielou:1961,ceyhan:eest-2010;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

cell.spec.ss(Y,cls)
cell.spec.ss.ct(ct)
cell.spec.ss.ct(ct,alt="g")

cell.spec.ss(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

cell.spec.ss(Y,fcls)
cell.spec.ss.ct(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

cell.spec.ss(Y,cls,alt="l")
cell.spec.ss.ct(ct)
cell.spec.ss.ct(ct,alt="l")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cell.spec.ct}} and \code{\link{cell.spec}}
}
\author{
Elvan Ceyhan
}
