% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{EV.tct}
\alias{EV.tct}
\title{Expected Values of the Types I-IV cell-specific tests}
\usage{
EV.tct(ct, type = "III")
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{type}{The type of the cell-specific test, default=\code{"III"}. Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}
}
\value{
A \code{matrix} of the expected values of Type I-IV cell-specific tests.
}
\description{
Returns a \code{matrix} of same dimension as, \code{ct}, whose entries are the expected values
of the \eqn{T_{ij}} values which are the Types I-IV cell-specific test statistics (i.e., \eqn{T^I_{ij}-T^{IV}_{ij}})
under RL or CSR. 
The row and column names are inherited from \code{ct}. The type argument specifies the type
of the cell-specific test among the types I-IV tests.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}) and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.tct(ct,2)
EV.tct(ct,"II")
EV.tctI(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)
EV.tct(ct,2)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.tct(ct,2)

ct<-matrix(c(0,10,5,5),ncol=2)
EV.tct(ct,2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{EV.tctI}}, \code{\link{tct}} and \code{\link{EV.nnct}}
}
\author{
Elvan Ceyhan
}
