% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readdb.R
\name{getNMADB}
\alias{getNMADB}
\title{NMA catalog}
\usage{
getNMADB()
}
\value{
A data.frame with the network meta-analyses included in [1]. 
Several characterstics related to the publications 
(e.g. Journal.Name, Title) are included in the data.frame.
}
\description{
Petropoulou et al. compiled a database of network meta-analyses to 
serve as a source for empirical studies Petropoulou (2016).
The database is hosted in a REDcap database at the 
Institute of Social and Preventive Medicine (ISPM) in the University of Bern.
Function getNMADB downloads the list of networks included in Petropoulou
(2016).
}
\examples{
catalog = getNMADB()
\dontrun{
  Networks that labeled Verified have outcome data 
  that allow the analysis to be repeated.
}
nmalist = catalog[catalog$Verified=="True",]
nmalist
}
\references{
Petropoulou M, Nikolakopoulou A A, Veroniki A, Rios P, Vafaei A,
Zarin W, Giannatsi M, Sullivan S, Tricco A C, Chaimani A, Egger M, Salanti G
(2016) <doi:10.1016/j.jclinepi.2016.11.002>.
}
