% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{tdMoments}
\alias{tdMoments}
\alias{tdMean}
\alias{tdVariance}
\alias{tdSkew}
\alias{tdKurtosis}
\alias{tdEntropy}
\title{Calculate moments for the fitted \code{timedist} model}
\usage{
tdMoments(r, c, t, ...)

tdMean(r, c, t, upper = t * 10, ...)

tdVariance(r, c, t, upper = t * 10, ...)

tdSkew(r, c, t, upper = t * 10, ...)

tdKurtosis(r, c, t, upper = t * 10, alternative = FALSE, ...)

tdEntropy(r, c, t, upper = t * 10, ...)
}
\arguments{
\item{r, c, t}{\code{numeric(1)}. Parameters of the Franco distribution.}

\item{...}{Additional arguments to be passed to \code{\link[stats:integrate]{stats::integrate()}}.}

\item{upper}{\code{numeric(1)}. The upper limit of integration. Defaults to \code{t * 10}. Can be infinite for all moment
functions except for entropy.}

\item{alternative}{\code{logical(1)}. Whether to use the alternative calculation method (\code{TRUE}) or not (default:
\code{FALSE}).}
}
\value{
For the individual summary statistic functions, a single \code{numeric}; for \code{tdMoments()}, a single row \code{data.frame} of
\code{numerics} containing all of the summary statistics as individual columns.
}
\description{
Calculate individual model summary statistics or use the wrapper, \code{tdMoments()}, to calculate all model summary
statistics.
}
\examples{
tdMoments(r = 0.1, c = 0.5, t = 120)

tdMean(r = 0.1, c = 0.5, t = 120)
tdVariance(r = 0.1, c = 0.5, t = 120)
tdSkew(r = 0.1, c = 0.5, t = 120)
tdKurtosis(r = 0.1, c = 0.5, t = 120)
tdKurtosis(r = 0.1, c = 0.5, t = 120, alternative = TRUE)
tdEntropy(r = 0.1, c = 0.5, t = 120)
}
