% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_ff}
\alias{simdesign_ff}
\title{Add a full-factorial simdesign to a nl object}
\usage{
simdesign_ff(nl, nseeds)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add a full-factorial simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a vector of distinct values (e.g. list(values=c(1,2,3,4)).
Or a sequence definition with min, max and step (e.g. list=(min=1, max=4, step=1)).
If both (values and sequence) are defined, the full-factorial design gives priority to the values.

The full-factorial simdesign uses these defined parameter ranges within the nl object.
A full-factorial matrix of all parameter combinations is created as input tibble for the simdesign.
Finally, the function reports a simdesign object.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_ff
nl@simdesign <- simdesign_ff(nl = nl, nseeds = 3)


}
