% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modellib.R
\name{modellib}
\alias{modellib}
\title{Get the model from the model library}
\usage{
modellib(name = NULL, eta = NULL, reserr = NULL)
}
\arguments{
\item{name}{character with the name of the model to load (if \code{NULL},
lists all available base models)}

\item{eta}{vector with the parameters to add random effects (sometimes
referred to as inter-individual variability, IIV) on}

\item{reserr}{The type or types of residual error (currently \code{"addSd"},
\code{"propSd"}, and \code{"lnormSd"} are accepted)}
}
\value{
The function returns a function the model code (or \code{NULL} if the
  \code{model = NULL})
}
\description{
This function gets a model from the available model library
}
\details{
This is a very first draft just to look at the proof of concept
}
\examples{
modellib(name="PK_1cmt")
modellib(name="PK_1cmt", eta = c("ka", "vc"), reserr = "addSd")
modellib(name="PK_1cmt", reserr = "addSd")
}
