% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saem_fit.R
\name{configsaem}
\alias{configsaem}
\title{Configure an SAEM model}
\usage{
configsaem(model, data, inits, mcmc = list(niter = c(200, 300), nmc = 3, nu =
  c(2, 2, 2)), ODEopt = list(atol = 1e-08, rtol = 1e-06, stiff = 1,
  transit_abs = 0), distribution = c("normal", "poisson", "binomial"),
  seed = 99)
}
\arguments{
\item{model}{a compiled saem model by gen_saem_user_fn()}

\item{data}{input data}

\item{inits}{initial values}

\item{mcmc}{a list of various mcmc options}

\item{ODEopt}{optional ODE solving options}

\item{distribution}{one of c("normal","poisson","binomial")}

\item{seed}{seed for random number generator}
}
\description{
Configure an SAEM model by generating an input list to the SAEM model function
}
\details{
Fit a generalized nonlinear mixed-effect model by he Stochastic
   Approximation Expectation-Maximization (SAEM) algorithm
}
\examples{
\dontrun{
library(nlmixr)

#ode <- "d/dt(depot) =-KA*depot;
#        d/dt(centr) = KA*depot - KE*centr;"
#m1 = RxODE(ode, modName="m1")
#ode <- "C2 = centr/V;
#      d/dt(depot) =-KA*depot;
#      d/dt(centr) = KA*depot - KE*centr;"
#m2 = RxODE(ode, modName="m2")

#Note: only use the '=' assignment, not the '<-' at this point

PKpars = function()
{
  CL = exp(lCL)
  V  = exp(lV)
  KA = exp(lKA)
  KE = CL / V
  #initCondition = c(0, KE - CL/V)
}
PRED = function() centr / V
PRED2 = function() C2

saem_fit <- gen_saem_user_fn(model=lincmt(ncmt=1, oral=T))
#saem_fit <- gen_saem_user_fn(model=m1, PKpars, pred=PRED)
#saem_fit <- gen_saem_user_fn(model=m2, PKpars, pred=PRED2)


#--- saem cfg
nmdat = read.table("theo_sd.dat",  head=T)
model = list(saem_mod=saem_fit, covars="WT")
inits = list(theta=c(.05, .5, 2))
cfg   = configsaem(model, nmdat, inits)
cfg$print = 50

#cfg$Rfn = nlmixr:::Ruser_function_cmt
#dyn.load("m1.d/m1.so");cfg$Rfn = nlmixr:::Ruser_function_ode
fit = saem_fit(cfg)
df = simple.gof(fit)
xyplot(DV~TIME|ID, df, type=c("p","l"), lwd=c(NA,1), pch=c(1,NA), groups=grp)
fit
}
}
\author{
Wenping Wang
}
