% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlive.inspect.R
\name{nlive.inspect}
\alias{nlive.inspect}
\title{Generation of key plots for a longitudinal variable of interest}
\usage{
nlive.inspect(
  dataset,
  ID,
  variable,
  time,
  plot.xlabel = NULL,
  plot.ylabel = NULL,
  spag.plot.title = NULL
)
}
\arguments{
\item{dataset}{data frame containing the ID, variable, and time.}

\item{ID}{name of the variable representing the grouping structure specified with " (e.g., "ID" representing the unique identifier of participants).}

\item{variable}{name of the time-varying variable of interest specified with " (e.g., "variable").}

\item{time}{name of the variable representing the timescale specified with " (e.g., "time"). Can be negative or positive.}

\item{plot.xlabel}{optional text for the title of the x-axis of all plots.}

\item{plot.ylabel}{optional text for the title of the y-axis of all plots.}

\item{spag.plot.title}{optional text for the title of the spaghetti plot.}
}
\value{
The \emph{nlive.inspect} function automatically provides
(i) an histogram of all the repeated measures of the variable available over time,
(ii) a spaghetti plot of the longitudinal observed variable for 70 randomly selected statistical units,
(iii) repeated boxplots of the longitudinal observed variable for each time unit.
The outputs are printed on the terminal and the numerical and graphical outputs are stored in a directory
}
\description{
The nlive.inspect() function allows to generate basic graphs to describe the longitudinal observed
measures of a variable of interest in the dataset
}
\examples{

\dontrun{
nlive.inspect(dataset=dataCog, ID="ID", variable="cognition", time="time")
}

}
\references{
Hadley Wickham (2016). ggplot2: elegant graphics for data analysis. Springer.
}
\author{
Maude Wagner, Ana W. Capuano, Emmanuelle Comets

\email{maude_wagner@rush.edu}
}
