% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageHeaping.R
\name{plot.ageHeaping}
\alias{plot.ageHeaping}
\title{\code{\link[=plot]{plot()}} helper functions for \code{\link[=ageHeaping]{ageHeaping()}} functions}
\usage{
\method{plot}{ageHeaping}(x, main = "", xlab = "Remainder", ylab = "Frequency", cex = 0.75, ...)
}
\arguments{
\item{x}{Object resulting from applying the \code{\link[=ageHeaping]{ageHeaping()}} function}

\item{main}{Title of plot}

\item{xlab}{\code{x-axis} label; default is \code{Remainder}}

\item{ylab}{\code{y-axis} label; default is \code{Frequency}}

\item{cex}{Character expansion (numeric); default is 0.75}

\item{...}{Additional \code{\link[=plot]{plot()}} graphical parameters}
}
\value{
Barplot of frequency of remainders of age when divided by a specified
divisor
}
\description{
\code{\link[=plot]{plot()}} helper functions for \code{\link[=ageHeaping]{ageHeaping()}} functions
}
\examples{
# Plot age heaping test results on SMART survey data in Kabul, Afghanistan
# (dp.ex02) using a divisor of 12
svy <- dp.ex02
ah12 <- ageHeaping(svy$age)
plot(ah12)

}
