% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbernppDetection_normal.R
\name{dbernppDetection_normal}
\alias{dbernppDetection_normal}
\alias{rbernppDetection_normal}
\title{Bernoulli point process detection model}
\usage{
dbernppDetection_normal(
  x,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  numWindows,
  indicator,
  log = 0
)

rbernppDetection_normal(
  n,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  numWindows,
  indicator
)
}
\arguments{
\item{x}{Vector with three elements representing the x- and y-coordinates and the id of the corresponding detection window for a single spatial point (detection location) scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}}).}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all detection windows scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}}). One row for each window. Each window should be of size 1x1.}

\item{s}{VVector of x- and y-coordinates of the isotropic bivariate normal distribution mean (i.e. the AC location)..}

\item{sd}{Standard deviation of the isotropic bivariate normal distribution.}

\item{baseIntensities}{Vector of baseline detection intensities for all detection windows.}

\item{numWindows}{Number of detection windows. This value (positive integer) is used to truncate \code{lowerCoords} and \code{upperCoords} 
so that extra rows beyond \code{numWindows} are ignored.}

\item{indicator}{Binary argument specifying whether the individual is available for detection (indicator = 1) or not (indicator = 0).}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
\code{dbernppDetection_normal} gives the (log) probability density of the observation vector \code{x}. 
\code{rbernppDetection_normal} gives coordinates of a randomly generated spatial point.
}
\description{
Density and random generation functions of the Bernoulli point process for detection.
}
\details{
The \code{dbernppDetection_normal} distribution is a NIMBLE custom distribution which can be used to model and simulate
Bernoulli observations (\emph{x}) of a single individual in continuous space over a set of detection windows defined by their upper and lower
coordinates (\emph{lowerCoords,upperCoords}). The distribution assumes that an individual’s detection probability 
follows an isotropic multivariate normal centered on the individual's activity center (\emph{s}) with standard deviation (\emph{sd}).
}
\examples{
coordsHabitatGridCenter <- matrix(c(0.5, 3.5,
                                    1.5, 3.5,
                                    2.5, 3.5,
                                    3.5, 3.5,
                                    0.5, 2.5,
                                    1.5, 2.5,
                                    2.5, 2.5,
                                    3.5, 2.5,
                                    0.5, 1.5,
                                    1.5, 1.5,
                                    2.5, 1.5,
                                    3.5, 1.5,
                                    0.5, 0.5,
                                    1.5, 0.5,
                                    2.5, 0.5,
                                    3.5, 0.5), ncol = 2,byrow = TRUE)
colnames(coordsHabitatGridCenter) <- c("x","y")
# Create observation windows
 lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
 upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
 colnames(lowerCoords) <- colnames(upperCoords) <- c("x","y")
# Rescale coordinates
ScaledLowerCoords <- scaleCoordsToHabitatGrid(coordsData =  lowerCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords <- scaleCoordsToHabitatGrid(coordsData =  upperCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords$coordsDataScaled[,2] <- ScaledUpperCoords$coordsDataScaled[,2] + 1.5
ScaledLowerCoords$coordsDataScaled[,2] <- ScaledLowerCoords$coordsDataScaled[,2] - 1.5


s <- c(1, 1)
sd <- 0.1
baseIntensities <- c(1:4)
windowIndex <- 4
numPoints <- 1
numWindows <- 4
indicator <- 1
x <- c(0.5, 2)
windowIndex <- getWindowIndex(curCoords = x,
                              lowerCoords = ScaledLowerCoords$coordsDataScaled,
                              upperCoords =ScaledUpperCoords$coordsDataScaled)
x <- c(x, windowIndex)

dbernppDetection_normal(x, lowerCoords, upperCoords,
                        s, sd, baseIntensities
                        , numWindows,
                        indicator, log = TRUE)
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang and Cyril Milleret
}
