% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimbleFunction_Rexecution.R
\name{nimOptim}
\alias{nimOptim}
\title{General-purpose Optimization}
\usage{
nimOptim(
  par,
  fn,
  gr = "NULL",
  ...,
  method = "Nelder-Mead",
  lower = -Inf,
  upper = Inf,
  control = nimOptimDefaultControl(),
  hessian = FALSE
)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{fn}{A function to be minimized (or maximized), with first argument the
vector of parameters over which minimization is to take place. It
should return a scalar result.}

\item{gr}{A function to return the gradient for the "BFGS", "CG" and "L-BFGS-B" methods.}

\item{...}{IGNORED}

\item{method}{The method to be used. See `Details` section of \code{\link{optim}}. One of:
"Nelder-Mead", "BFGS", "CG", "L-BFGS-B".
Note that the R methods "SANN", "Brent" are not supported.}

\item{lower}{Vector or scalar of lower bounds for parameters.}

\item{upper}{Vector or scalar of upper bounds for parameters.}

\item{control}{A list of control parameters. See \code{Details} section of \code{\link{optim}}.}

\item{hessian}{Logical. Should a Hessian matrix be returned?}
}
\value{
\code{\link{optimResultNimbleList}}
}
\description{
NIMBLE wrapper around R's builtin \code{\link{optim}}.
}
\examples{
\dontrun{
objectiveFunction <- nimbleFunction(
    run = function(par = double(1)) {
        return(sum(par) * exp(-sum(par ^ 2) / 2))
        returnType(double(0))
    }
)
optimizer <- nimbleFunction(
    run = function(method = character(0), fnscale = double(0)) {
        control <- optimDefaultControl()
        control$fnscale <- fnscale
        par <- c(0.1, -0.1)
        return(optim(par, objectiveFunction, method = method, control = control))
        returnType(optimResultNimbleList())
    }
)
cOptimizer <- compileNimble(optimizer)
cOptimizer(method = 'BFGS', fnscale = -1)
}
}
\seealso{
\code{\link{optim}}
}
