% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_configuration.R
\name{configureMCMC}
\alias{configureMCMC}
\title{Build the MCMCconf object for construction of an MCMC object}
\usage{
configureMCMC(model, nodes, control = list(), monitors, thin = 1,
  monitors2 = character(), thin2 = 1, useConjugacy = TRUE,
  onlyRW = FALSE, onlySlice = FALSE,
  multivariateNodesAsScalars = getNimbleOption("MCMCmultivariateNodesAsScalars"),
  enableWAIC = getNimbleOption("MCMCenableWAIC"), print = FALSE,
  autoBlock = FALSE, oldConf,
  rules = getNimbleOption("MCMCdefaultSamplerAssignmentRules"),
  warnNoSamplerAssigned = TRUE, ...)
}
\arguments{
\item{model}{A NIMBLE model object, created from \code{\link{nimbleModel}}}

\item{nodes}{An optional character vector, specifying the nodes and/or variables for which samplers should be created.
Nodes may be specified in their indexed form, \code{y[1, 3]}.  Alternatively, nodes specified without indexing will be expanded fully, e.g., \code{x} will be expanded to \code{x[1]}, \code{x[2]}, etc.
If missing, the default value is all non-data stochastic nodes.
If NULL, then no samplers are added.}

\item{control}{An optional list of control arguments to sampler functions.  If a control list is provided, the elements will be provided to all sampler functions which utilize the named elements given.
For example, the standard Metropolis-Hastings random walk sampler (\link{sampler_RW}) utilizes control list elements \code{adaptive}, \code{adaptInterval}, and \code{scale}.
(Internally it also uses \code{targetNode}, but this should not generally be provided as a control list element).
The default values for control list arguments for samplers (if not otherwise provided as an argument to configureMCMC() ) are in the setup code of the sampling algorithms.}

\item{monitors}{A character vector of node names or variable names, to record during MCMC sampling.
This set of monitors will be recorded with thinning interval \code{thin}, and the samples will be stored into the \code{mvSamples} object.
The default value is all top-level stochastic nodes of the model -- those having no stochastic parent nodes.}

\item{thin}{The thinning interval for \code{monitors}.  Default value is one.}

\item{monitors2}{A character vector of node names or variable names, to record during MCMC sampling.
This set of monitors will be recorded with thinning interval \code{thin2}, and the samples will be stored into the \code{mvSamples2} object.
The default value is an empty character vector, i.e. no values will be recorded.}

\item{thin2}{The thinning interval for \code{monitors2}.  Default value is one.}

\item{useConjugacy}{A logical argument, with default value TRUE.  If specified as FALSE, then no conjugate samplers will be used, even when a node is determined to be in a conjugate relationship.}

\item{onlyRW}{A logical argument, with default value FALSE.  If specified as TRUE, then Metropolis-Hastings random walk samplers (\link{sampler_RW}) will be assigned for all non-terminal continuous-valued nodes nodes. Discrete-valued nodes are assigned a slice sampler (\link{sampler_slice}), and terminal nodes are assigned a posterior_predictive sampler (\link{sampler_posterior_predictive}).}

\item{onlySlice}{A logical argument, with default value FALSE.  If specified as TRUE, then a slice sampler is assigned for all non-terminal nodes. Terminal nodes are still assigned a posterior_predictive sampler.}

\item{multivariateNodesAsScalars}{A logical argument, with default value FALSE.  If specified as TRUE, then non-terminal multivariate stochastic nodes will have scalar samplers assigned to each of the scalar components of the multivariate node.  The default value of FALSE results in a single block sampler assigned to the entire multivariate node.  Note, multivariate nodes appearing in conjugate relationships will be assigned the corresponding conjugate sampler (provided \code{useConjugacy == TRUE}), regardless of the value of this argument.}

\item{enableWAIC}{A logical argument, specifying whether to enable WAIC calculations for the resulting MCMC algorithm.  Defaults to the value of \code{nimbleOptions('MCMCenableWAIC')}, which in turn defaults to FALSE.  Setting \code{nimbleOptions('enableWAIC' = TRUE)} will ensure that WAIC is enabled for all calls to \code{\link{configureMCMC}} and \code{\link{buildMCMC}}.}

\item{print}{A logical argument, specifying whether to print the ordered list of default samplers.}

\item{autoBlock}{A logical argument specifying whether to use an automated blocking procedure to determine blocks of model nodes for joint sampling.  If TRUE, an MCMC configuration object will be created and returned corresponding to the results of the automated parameter blocking.  Default value is FALSE.}

\item{oldConf}{An optional MCMCconf object to modify rather than creating a new MCMCconf from scratch}

\item{rules}{An object of class samplerAssignmentRules, which governs the assigment of MCMC sampling algorithms to stochastic model nodes.  The default set of sampler assignment rules is specified by the nimble option \'MCMCdefaultSamplerAssignmentRules\'.}

\item{warnNoSamplerAssigned}{A logical argument, with default value TRUE.  This specifies whether to issue a warning when no sampler is assigned to a node, meaning there is no matching sampler assignment rule.}

\item{...}{Additional named control list elements for default samplers, or additional arguments to be passed to the \code{\link{autoBlock}} function when \code{autoBlock = TRUE}}
}
\description{
Creates a defaut MCMC configuration for a given model.  The resulting object is suitable as an argument to \code{\link{buildMCMC}}. The assignment of sampling algorithms may be controlled using the \code{rules} argument, if provided.
}
\details{
See \code{\link{MCMCconf}} for details on how to manipulate the \code{MCMCconf} object
}
\author{
Daniel Turek
}
\seealso{
\code{\link{samplerAssignmentRules}} \code{\link{buildMCMC}} \code{\link{runMCMC}} \code{\link{nimbleMCMC}}
}

