% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nimbleList_core.R
\name{nimbleList}
\alias{nimbleList}
\title{create a nimbleList}
\usage{
nimbleList(..., name = NA, predefined = FALSE,
  where = getNimbleFunctionEnvironment())
}
\arguments{
\item{...}{arbitrary set of names and types for the elements of the list or a single R list of type \code{nimbleType}.}

\item{name}{optional character providing a name used internally, for example in generated C++ code.  Usually this is left blank and NIMBLE provides a name.}

\item{predefined}{logical for internal use only.}

\item{where}{optional argument passed to \code{setRefClass} for where the reference class definition generated for this nimbleFunction will be stored.  This is needed due to R package namespace issues but should never need to be provided by a user.}
}
\description{
create a nimbleList from a nimbleList definition
}
\details{
This function creates a definition for a nimbleList.  The \code{types} argument defines the names, types, and dimensions of the elements of the nimbleList.  Elements of nimbleLists can be either basic types (e.g., \code{integer}, \code{double}) or other nimbleList definitions.
The \code{types} argument can be either a series of expressions of the form \code{name = type(dim)}, or a list of \link{nimbleType} objects.

\code{nimbleList} returns a definition, which can be used to create instances of this type of nimbleList via the \code{new()} member function.

Definitions can be created in R's general environment or in nimbleFunction setup code.  Instances can be created using the \code{new()} function in R's global environment, in nimbleFunction setup code, or in nimbleFunction run code.

Instances of \code{nimbleList} definitions can be used as arguments to run code of nimbleFunctions, and as the return type of nimbleFunctions.
}
\examples{
exampleNimListDef <- nimbleList(x = integer(0), Y = double(2))

 nimbleListTypes <- list(nimbleType(name = 'x', type = 'integer', dim = 0),
                         nimbleType(name = 'Y', type = 'double', dim = 2))

 ## this nimbleList definition is identical to the one created above
 exampleNimListDef <- nimbleList(nimbleListTypes)
}
\author{
NIMBLE development team
}

