% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb24cafbcd5
\name{buildMCEM}
\alias{buildMCEM}
\title{Builds an MCEM algorithm from a given NIMBLE model}
\usage{
buildMCEM(model, latentNodes, burnIn = 100, mcmcControl = list(adaptInterval
  = 20), boxConstraints = list(), buffer = 10^-6)
}
\arguments{
\item{model}{A nimble model}\item{latentNodes}{A character vector of the names of the stochastic nodes to integrated out. Names can be expanded, but don't need to be. For example, if the model contains
\code{x[1], x[2] and x[3]} then one could provide either \code{latentNodes = c('x[1]', 'x[2]', 'x[3]')} or \code{latentNodes = 'x'}.}

\item{burnIn}{burn-in used for MCMC sampler in E step}\item{mcmcControl}{list passed to \code{MCMCSpec}, a nimble function that builds the MCMC sampler. See \code{help(MCMCSpec)} for more details}\item{boxConstraints}{A list of box constraints for the nodes that will be maximized over. Each constraint is a list in which the first element is a character vector of node names to which the constraint applies and the second element is a vector giving the lower and upper limits.  Limits of \code{-Inf} or \code{Inf} are allowed.}\item{buffer}{A buffer amount for extending the boxConstraints. Many functions with boundary constraints will produce \code{NaN} or -Inf when parameters are on the boundary.  This problem can be prevented by shrinking the boundary a small amount.}}\value{
an R function that when called runs the MCEM algorithm. The function returned takes the arguments listed in Runtime Arguments.


See user manual for more
}
\description{
Takes a nimble model and builds an MCEM algorithm for it. The user must specify which latent nodes are to be integrated out in the E-Step.
All other stochastic non-data nodes will be maximized over. If the nodes do not have positive density on the entire real line, then box constraints can be used
to enforce this.
The M-step is done by a nimble MCMC sampler. The E-step is done by a call to R's \code{optim} with \code{method = 'L-BFGS-B'}.
}
\details{
buildMCEM calls the NIMBLE compiler to create the MCMC and objective function as nimbleFunctions.  If the given model has already been used in compiling other nimbleFunctions, it is possible you will need to create a new copy of the model for buildMCEM to use.
}
\section{Runtime Arguments}{

	\itemize{
	\item{\code{maxit}}	{

	 Maximum iterations of the algorithm. Right now, the MCEM runs until \code{maxit}, rather than evaluating a more complex stopping criteria}

	\item{\code{m1}} 	{

	 number of MCMC samples taken in each iteration before \code{maxit/2}}

	\item{\code{m2}}	{

	number of MCMC samples taken in each iteration after \code{maxit/2} }
	}
}
\examples{
pumpCode <- nimbleCode({
 for (i in 1:N){
     theta[i] ~ dgamma(alpha,beta);
     lambda[i] <- theta[i]*t[i];
     x[i] ~ dpois(lambda[i])
 }
 alpha ~ dexp(1.0);
 beta ~ dgamma(0.1,1.0);
})

pumpConsts <- list(N = 10,
              t = c(94.3, 15.7, 62.9, 126, 5.24,
                31.4, 1.05, 1.05, 2.1, 10.5))

pumpData <- list(x = c(5, 1, 5, 14, 3, 19, 1, 1, 4, 22))

pumpInits <- list(alpha = 1, beta = 1,
             theta = rep(0.1, pumpConsts$N))
pumpModel <- nimbleModel(code = pumpCode, name = 'pump', constants = pumpConsts,
                  data = pumpData, inits = pumpInits)

# Want to maximize alpha and beta (both which must be positive) and integrate over theta
box = list( list(c('alpha','beta'), c(0, Inf)))

\dontrun{
pumpMCEM <- buildMCEM(model = pumpModel, latentNodes = 'theta[1:10]',
                       boxConstraints = box)
pumpMCEM(maxit = 40, m1 = 1000, m2 = 5000)
}

# Could also use latentNodes = 'theta' and buildMCEM would figure out this means 'theta[1:10]'
}
\author{
Clifford Anderson-Bergman
}

