% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVI.R
\name{AVI}
\alias{AVI}
\title{AVI - Advanced Vegetation Index}
\usage{
AVI(R, NIR)
}
\arguments{
\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
AVI - Advanced Vegetation Index
}
\description{
AVI is similar to NDVI and it is used in vegetation studies to monitor crop and forest variations over time. Through the multi-temporal combination of the AVI and the NDVI, users can discriminate different types of vegetation and extract phenology characteristics.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
AVI(x[[4]], x[[5]])

}
\references{
Rikimaru et al., 2002. Tropical forest cover density mapping. Tropical Ecology, 43, 39-47.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
