% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_cumulative_intensity_orderstats.R
\name{draw_cumulative_intensity_orderstats}
\alias{draw_cumulative_intensity_orderstats}
\title{Simulate from a non homogeneous Poisson Point Process (NHPPP) from
(t_min, t_max) (order statistics method)}
\usage{
draw_cumulative_intensity_orderstats(
  Lambda,
  Lambda_inv,
  t_min,
  t_max,
  atmost1 = FALSE
)
}
\arguments{
\item{Lambda}{(function, double vector) a continuous increasing R to R map
which is the integrated rate of the NHPPP}

\item{Lambda_inv}{(function, double vector) the inverse of \code{Lambda()}}

\item{t_min}{(double) the lower bound of the time interval}

\item{t_max}{(double) the upper bound of the time interval}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times (t_); if no events realize,
a vector of length 0
}
\description{
Sample NHPPP times using the order statistics method,
optionally using an \code{rstream} generator object.
}
\keyword{internal}
