% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdraw_intensity_step_regular_cpp.R
\name{vdraw_intensity_step_regular_cpp}
\alias{vdraw_intensity_step_regular_cpp}
\title{Vectorized sampling from a non homogeneous Poisson Point Process (NHPPP) from
an interval (thinning method) with piecewise constant_majorizers (C++)}
\usage{
vdraw_intensity_step_regular_cpp(
  lambda = NULL,
  lambda_args = NULL,
  Lambda_maj_matrix = NULL,
  lambda_maj_matrix = NULL,
  range_t = NULL,
  subinterval = NULL,
  tol = 10^-6,
  atmost1 = FALSE,
  atmostB = NULL
)
}
\arguments{
\item{lambda}{(function) a vectorized intensity function, with one or two arguments.
The first is time. The optional second is a named list with additional arguments.}

\item{lambda_args}{(list) optional list of named arguments for \code{lambda()}}

\item{Lambda_maj_matrix}{(matrix) for the majorizeintegrated intensity rates at the end of each interval}

\item{lambda_maj_matrix}{(matrix) intensity rates, one per interval}

\item{range_t}{(vector, or matrix) \code{t_min} and \code{t_max}, possibly vectorized}

\item{subinterval}{(matrix, double) subinterval of \code{range_t} to sample from}

\item{tol}{(scalar, double) tolerance for the number of events}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atmostB}{If not NULL, draw at most B (B>0) event times. NULL means ignore.}
}
\value{
a matrix of event times (columns) per draw (rows)
NAs are structural empty spots
}
\description{
Vectorized sampling from a non homogeneous Poisson Point Process (NHPPP) from
an interval (thinning method) with piecewise constant_majorizers.
The majorizers are step functions over equal-length time intevals.
}
\examples{
Z <- vdraw_intensity_step_regular_cpp(
  lambda = function(x, lambda_args = NULL) 0.1 * x,
  range_t = c(1, 10),
  lambda_maj_matrix = matrix(rep(1, 5), nrow = 1)
)
}
