% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoalieEDGE.R
\name{goalie_edge_summary}
\alias{goalie_edge_summary}
\title{Access the EDGE summary for a goalie, season, and game type}
\usage{
goalie_edge_summary(player = 8476945, season = "now", game_type = "")
}
\arguments{
\item{player}{integer ID (e.g., 8478406)}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference; most functions
will NOT support pre-season}
}
\value{
list of various items
}
\description{
\code{goalie_edge_summary()} scrapes the EDGE summary for a given set of
\code{goalie}, \code{season}, and \code{game_type}.
}
\examples{
Mackenzie_Blackwood_EDGE_summary_regular_20242025 <- goalie_edge_summary(
  player    = 8478406, 
  season    = 20242025,
  game_type = 2
)
}
