% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nldi.R
\name{get_nldi_basin}
\alias{get_nldi_basin}
\title{Get NLDI Basin Boundary}
\usage{
get_nldi_basin(nldi_feature, tier = "prod")
}
\arguments{
\item{nldi_feature}{list with names `featureSource` and `featureID` where
`featureSource` is derived from the "source" column of  the response of
discover_nldi_sources() and the `featureSource` is a known identifier
from the specified `featureSource`.}

\item{tier}{character optional "prod" or "test"}
}
\value{
sf data.frame with result basin boundary
}
\description{
Get a basin boundary for a given NLDI feature.
}
\details{
Only resolves to the nearest NHDPlus catchment divide. See:
https://owi.usgs.gov/blog/nldi-intro/ for more info on the nldi.
}
\examples{
library(sf)
library(dplyr)

nldi_nwis <- list(featureSource = "nwissite", featureID = "USGS-05428500")

basin <- get_nldi_basin(nldi_feature = nldi_nwis)

basin \%>\%
 st_geometry() \%>\%
 plot()

basin

}
