% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTableVars}
\alias{nhanesTableVars}
\title{Displays a list of variables in the specified NHANES table.}
\usage{
nhanesTableVars(
  data_group,
  nh_table,
  details = FALSE,
  nchar = 100,
  namesonly = FALSE
)
}
\arguments{
\item{data_group}{The type of survey (DEMOGRAPHICS, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{nh_table}{The name of the specific table to retrieve.}

\item{details}{If TRUE then all columns in the variable description are returned (default=FALSE).}

\item{nchar}{The number of characters in the Variable Description to print. Values are limited to 0<=nchar<=128.
This is used to enhance readability, cause variable descriptions can be very long.}

\item{namesonly}{If TRUE then only the variable names are returned (default=FALSE).}
}
\value{
Returns a data frame that describes variable attributes for the specified table. If namesonly=TRUE,
then a character vector of the variable names is returned.
}
\description{
Enables quick display of table variables and their definitions.
}
\details{
NHANES tables may contain more than 100 variables. Function nhanesTableVars provides a concise display
of variables for a specified table, which helps to ascertain quickly if the table is of interest. 
NULL is returned when an HTML read error is encountered.
}
\examples{
\donttest{nhanesTableVars('LAB', 'CBC_E')}
\donttest{nhanesTableVars('EXAM', 'OHX_E', details=TRUE, nchar=50)}
\donttest{nhanesTableVars('DEMO', 'DEMO_F', namesonly = TRUE)}
}
