% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{make_option}
\alias{make_option}
\title{Functions to enable our OptionParser to recognize specific command line options (optparse).}
\usage{
make_option(...)
}
\arguments{
\item{...}{Parameters pass to \code{\link[optparse]{make_option}}}
}
\description{
Functions to enable our OptionParser to recognize specific command line options (optparse).
}
\examples{
# example from vignette
option_list <- list(
  make_option(c('-v', '--verbose'), action='store_true', default=TRUE,
      help='Print extra output [default]'),
  make_option(c('-q', '--quietly'), action='store_false',
      dest='verbose', help='Print little output'),
  make_option(c('-c', '--count'), type='integer', default=5,
      help='Number of random normals to generate [default \%default]',
      metavar='number'),
  make_option('--generator', default='rnorm',
      help = 'Function to generate random deviates [default \\'\%default\\']'),
  make_option('--mean', default=0,
      help='Mean if generator == \\'rnorm\\' [default \%default]'),
  make_option('--sd', default=1, metavar='standard deviation',
      help='Standard deviation if generator == \\'rnorm\\' [default \%default]')
 )
}
