% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcount.r
\docType{methods}
\name{wordcount}
\alias{wordcount}
\alias{wordcount,character-method}
\alias{wordcount,ngram-method}
\title{wordcount}
\usage{
wordcount(x, sep = " ", count.function = sum)

\S4method{wordcount}{character}(x, sep = " ", count.function = sum)

\S4method{wordcount}{ngram}(x, sep = " ", count.function = sum)
}
\arguments{
\item{x}{A string or vector of strings, or an ngram object.}

\item{sep}{The characters used to separate words.}

\item{count.function}{The function to use for aggregation.}
}
\value{
A count.
}
\description{
\code{wordcount()} counts words.  Currently a "word" is a clustering of
characters separated from another clustering of charactersby at least 1
space.  That is the law.
}
\examples{
library(ngram)

words <- c("a", "b", "c")
words
wordcount(words)

str <- concatenate(words, collapse="")
str
wordcount(str)

}
\seealso{
\code{\link{preprocess}}
}
\keyword{Summarize}

