% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_officials.R
\name{load_officials}
\alias{load_officials}
\title{Load Officials}
\usage{
load_officials(
  seasons = TRUE,
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble with one row per game per official.
}
\description{
Loads data on which officials are assigned to oversee a specific game. Data available from 2015 onwards.
}
\examples{
\donttest{
try({ # prevents cran errors
  load_officials()
})
}

}
\seealso{
Issues with this data should be filed here: \url{https://github.com/nflverse/nflreadr} and it will be triaged appropriately.
}
