% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nflverse.R
\name{load_nextgen_stats}
\alias{load_nextgen_stats}
\title{Load Player Level Weekly NFL Next Gen Stats}
\usage{
load_nextgen_stats(
  seasons = TRUE,
  stat_type = c("passing", "receiving", "rushing"),
  file_type = getOption("nflreadr.prefer", default = "qs")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{stat_type}{one of \code{"passing"}, \code{"receiving"}, or \code{"rushing"}}

\item{file_type}{One of \code{"rds"} or \code{"qs"}. Can also be set globally with options(nflreadr.prefer)}
}
\value{
A tibble of week-level player statistics provided by NFL Next Gen Stats.
Regular season summary is given for \code{week == 0}.
}
\description{
Loads player level weekly stats provided by NFL Next Gen Stats
starting with the 2016 season. Three different stat types are available and
the current season's data updates every night.
}
\examples{
\donttest{
  load_nextgen_stats(stat_type = "passing")
  load_nextgen_stats(stat_type = "receiving")
  load_nextgen_stats(stat_type = "rushing")
}

}
\seealso{
\url{https://nextgenstats.nfl.com/stats/passing} for \code{stat_type = "passing"}

\url{https://nextgenstats.nfl.com/stats/receiving} for \code{stat_type = "receiving"}

\url{https://nextgenstats.nfl.com/stats/rushing} for \code{stat_type = "rushing"}

\code{\link{dictionary_nextgen_stats}} for the data dictionary

\url{https://nflreadr.nflverse.com/articles/dictionary_nextgen_stats.html} for a web version of the dictionary
}
