% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_additional_functions.R
\name{clean_pbp}
\alias{clean_pbp}
\title{Clean Play by Play Data}
\usage{
clean_pbp(pbp, ...)
}
\arguments{
\item{pbp}{is a Data frame of play-by-play data scraped using \code{\link[=fast_scraper]{fast_scraper()}}.}

\item{...}{Additional arguments passed to a message function (for internal use).}
}
\value{
The input Data Frame of the parameter 'pbp' with the following columns
added:
\describe{
\item{success}{Binary indicator wheter epa > 0 in the given play. }
\item{passer}{Name of the dropback player (scrambles included) including plays with penalties.}
\item{passer_jersey_number}{Jersey number of the passer.}
\item{rusher}{Name of the rusher (no scrambles) including plays with penalties.}
\item{rusher_jersey_number}{Jersey number of the rusher.}
\item{receiver}{Name of the receiver including plays with penalties.}
\item{receiver_jersey_number}{Jersey number of the receiver.}
\item{pass}{Binary indicator if the play was a pass play (sacks and scrambles included).}
\item{rush}{Binary indicator if the play was a rushing play.}
\item{special}{Binary indicator if the play was a special teams play.}
\item{first_down}{Binary indicator if the play ended in a first down.}
\item{aborted_play}{Binary indicator if the play description indicates "Aborted".}
\item{play}{Binary indicator: 1 if the play was a 'normal' play (including penalties), 0 otherwise.}
\item{passer_id}{ID of the player in the 'passer' column.}
\item{rusher_id}{ID of the player in the 'rusher' column.}
\item{receiver_id}{ID of the player in the 'receiver' column.}
\item{name}{Name of the 'passer' if it is not 'NA', or name of the 'rusher' otherwise.}
\item{fantasy}{Name of the rusher on rush plays or receiver on pass plays.}
\item{fantasy_id}{ID of the rusher on rush plays or receiver on pass plays.}
\item{fantasy_player_name}{Name of the rusher on rush plays or receiver on pass plays (from official stats).}
\item{fantasy_player_id}{ID of the rusher on rush plays or receiver on pass plays (from official stats).}
\item{jersey_number}{Jersey number of the player listed in the 'name' column.}
\item{id}{ID of the player in the 'name' column.}
\item{qb_epa}{Gives QB credit for EPA for up to the point where a receiver lost a fumble after a completed catch and makes EPA work more like passing yards on plays with fumbles.}
\item{out_of_bounds}{1 if play description contains ran ob, pushed ob, or sacked ob; 0 otherwise.}
}
}
\description{
Clean Play by Play Data
}
\details{
Build columns that capture what happens on all plays, including
penalties, using string extraction from play description.
Loosely based on Ben's nflfastR guide (\url{https://www.nflfastr.com/articles/beginners_guide.html})
but updated to work with the RS data, which has a different player format in
the play description; e.g. 24-M.Lynch instead of M.Lynch.
The function also standardizes team abbreviations so that, for example,
the Chargers are always represented by 'LAC' regardless of which year it was.
}
\seealso{
For information on parallel processing and progress updates please
see \link{nflfastR}.
}
