% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{add_4th_probs}
\alias{add_4th_probs}
\title{Get 4th down decision probabilities}
\usage{
add_4th_probs(df)
}
\arguments{
\item{df}{A data frame of decisions to be computed for.}
}
\value{
Original data frame Data frame plus the following columns added:
\describe{
\item{go_boost}{Gain (or loss) in win prob associated with choosing to go for it (percentage points).}
\item{first_down_prob}{Probability of earning a first down if going for it on 4th down.}
\item{wp_fail}{Win probability in the event of a failed 4th down attempt.}
\item{wp_succeed}{Win probability in the event of a successful 4th down attempt.}
\item{go_wp}{Average win probability when going for it on 4th down.}
\item{fg_make_prob}{Probability of making field goal.}
\item{miss_fg_wp}{Win probability in the event of a missed field goal.}
\item{make_fg_wp}{Win probability in the event of a made field goal.}
\item{fg_wp}{Average win probability when attempting field goal.}
\item{punt_wp}{Average win probability when punting.}
}
}
\description{
Get various probabilities associated with each option on 4th downs (go
for it, kick field goal, punt).
}
\examples{
\dontshow{if (identical(data.table::getDTthreads(FALSE), 2L) || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
\donttest{
play <-
  tibble::tibble(
    # things to help find the right game (use "reg" or "post")
    home_team = "GB",
    away_team = "TB",
    posteam = "GB",
    type = "post",
    season = 2020,

    # information about the situation
    qtr = 4,
    quarter_seconds_remaining = 129,
    ydstogo = 8,
    yardline_100 = 8,
    score_differential = -8,

    home_opening_kickoff = 0,
    posteam_timeouts_remaining = 3,
    defteam_timeouts_remaining = 3
  )

probs <- nfl4th::add_4th_probs(play)

dplyr::glimpse(probs)
}
\dontshow{\}) # examplesIf}
}
