% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/common.R
\docType{methods}
\name{splitReduce}
\alias{splitReduce}
\alias{splitReduce,BrainVector,factor,function-method}
\alias{splitReduce,BrainVector,factor,missing-method}
\alias{splitReduce,matrix,factor,function-method}
\alias{splitReduce,matrix,factor,missing-method}
\alias{splitReduce,matrix,integer,function-method}
\alias{splitReduce,matrix,integer,missing-method}
\title{Generic function to summarize subsets of an object by first splitting by row and then "reducing" by a summary \code{function}}
\usage{
splitReduce(x, fac, FUN)

\S4method{splitReduce}{matrix,integer,`function`}(x, fac, FUN)

\S4method{splitReduce}{matrix,integer,missing}(x, fac)

\S4method{splitReduce}{matrix,factor,missing}(x, fac)

\S4method{splitReduce}{matrix,factor,`function`}(x, fac, FUN)

\S4method{splitReduce}{BrainVector,factor,`function`}(x, fac, FUN)

\S4method{splitReduce}{BrainVector,factor,missing}(x, fac, FUN)
}
\arguments{
\item{x}{a numeric matrix(like) object}

\item{fac}{the factor to define subsets of the object}

\item{FUN}{the function to apply to each subset. if \code{FUN} is missing, than the mean of each sub-matrix column is computed.}
}
\value{
a new \code{matrix} where the original values have been reduced
}
\description{
Generic function to summarize subsets of an object by first splitting by row and then "reducing" by a summary \code{function}
}
\details{
if \code{FUN} is supplied it must take a vector and return a single scalar value. If it returns more than one value, an error will occur.

if \code{x} is a \code{BrainVector} instance then voxels (dims 1:3) are treated as columns and time-series (dim 4) as rows.
The summary function then is applied to groups of voxels. However, if the goal is to apply a function to groups of time-points,
then this can be achieved as follows:

\code{ splitReduce(t(as.matrix(bvec)), fac) }
}
\examples{
mat = matrix(rnorm(100*100), 100, 100)
fac = sample(1:3, nrow(mat), replace=TRUE)
## compute column means of each sub-matrix
ms <- splitReduce(mat, fac)
all.equal(row.names(ms), levels(fac))

## compute column medians of each sub-matrix
ms <- splitReduce(mat, fac, median)

## compute time-series means grouped over voxels.
## Here, \\code{length(fac)} must equal the number of voxels: \\code{prod(dim(bvec)[1:3]}
bvec <- BrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), BrainSpace(c(24,24,24,24), c(1,1,1)))
fac <- factor(sample(1:3, prod(dim(bvec)[1:3]), replace=TRUE))
ms <- splitReduce(bvec, fac)
ms2 <- splitReduce(bvec, fac, mean)
all.equal(row.names(ms), levels(fac))
all.equal(ms,ms2)
}

