% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.nifti.R
\name{density.nifti}
\alias{density.nifti}
\alias{density.anlz}
\title{Density of Values in an Image}
\usage{
\method{density}{nifti}(x, ..., mask)

\method{density}{anlz}(x, ..., mask)
}
\arguments{
\item{x}{Object of class \code{nifti}}

\item{...}{Arguments passed to \code{\link{density.default}}}

\item{mask}{object to subset the image.  If missing, then all 
values of the image are plotted.}
}
\value{
Output of \code{\link{density}}
}
\description{
Computes the density of values
of an image with the option for a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 0
density(img, mask = mask)
}
