% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.global.impact}
\alias{plot.global.impact}
\title{Plot "global.impact" objects}
\usage{
\method{plot}{global.impact}(x, order = c("given", "value",
  "alphabetical"), zscore = FALSE, abs_val = FALSE, ...)
}
\arguments{
\item{x}{an output object from an impact function (class \code{global.impact})}

\item{order}{"alphabetical" orders nodes alphabetically, "value" orders nodes from
highest to lowest impact value}

\item{zscore}{logical. Converts raw impact statistics to z-scores for plotting}

\item{abs_val}{logical. Plot absolute values of global strength impacts.
If both abs_val=TRUE and zscore=TRUE, plots the absolute value of the z-scores.}

\item{...}{other plotting specifications (ggplot2)}
}
\description{
Convenience function for generating global strength impact plots
}
\details{
Inputting an object of class \code{global.impact}
will return a line plot that shows the relative global impacts of each node.
}
\examples{
out <- impact(depression[,1:5])
plot(out$Global.Strength)
}
