% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rank.intervals.R
\name{plot_rank_intervals}
\alias{plot_rank_intervals}
\title{Plot rank intervals}
\usage{
plot_rank_intervals(P, cent.df, ties.method = "min")
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{cent.df}{A data frame containing centrality scores of indices (optional). See Details.}

\item{ties.method}{String specifying how ties are treated in the base \code{\link[base]{rank}} function.}
}
\value{
a ggplot object.
}
\description{
Compute rank intervals (minimal and maximal possible rank) and visualize them with ggplot.
}
\details{
If a data frame of centrality scores is added, the respective ranks of nodes are
shown in the intervals. Note that some points might fall outside of the
intervals depending how ties are treated.
}
\examples{
library(igraph)
library(ggplot2)
g <- graph.empty(n=11,directed = FALSE)
g <- add_edges(g,c(1,11,2,4,3,5,3,11,4,8,5,9,5,11,6,7,6,8,
                   6,10,6,11,7,9,7,10,7,11,8,9,8,10,9,10))
P <- neighborhood_inclusion(g)
\dontrun{plot_rank_intervals(P)}

#adding index based rankings
cent_scores <- data.frame(
  degree = degree(g),
  betweenness = round(betweenness(g),4),
  closeness = round(closeness(g),4),
  eigenvector = round(eigen_centrality(g)$vector,4))
\dontrun{plot_rank_intervals(P,cent.df=cent_scores)}
}
\seealso{
\link{rank_intervals}
}
\author{
David Schoch
}
