% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_apply.R
\docType{methods}
\name{net_apply}
\alias{net_apply}
\alias{net_apply,Net,ANY,ANY,ANY-method}
\alias{net_apply,NetSample,ANY,ANY,missing-method}
\title{Apply a network manipulation function to a single network, or to a sample of
networks}
\usage{
net_apply(network, net.function, net.function.args, orig.net.name)

\S4method{net_apply}{Net,ANY,ANY,ANY}(network, net.function,
  net.function.args, orig.net.name)

\S4method{net_apply}{NetSample,ANY,ANY,missing}(network, net.function,
  net.function.args, orig.net.name)
}
\arguments{
\item{network}{An \code{Net} object or a \code{NetSample} object}

\item{net.function}{A network manipulation function (reference or character)}

\item{net.function.args}{A labeled list containing arguments to the
net.function}

\item{orig.net.name}{The original network name, when applying net_apply to a
\code{Net}}
}
\value{
A \code{NetSet} or \code{NetSampleSet} object
}
\description{
This function applies a network manipulation function to a single network or
sample of networks, and returns a NetSet, or NetSampleSet containing the
results.
}
\section{Methods (by class)}{
\itemize{
\item \code{network = Net,net.function = ANY,net.function.args = ANY,orig.net.name = ANY}: net_apply for Net

\item \code{network = NetSample,net.function = ANY,net.function.args = ANY,orig.net.name = missing}: net_apply for NetSample
}}

\examples{
data(GroupA)
GroupA_Net = as_NetSample(GroupA, 1:20, node.variables = list(community = c(rep(1, 10), rep(2,10))),
 sample.variables = list(group = c(rep(1, 10), rep(2,10))))
Jackknife_GroupA_Net = net_apply(GroupA_Net, node_jackknife)
}
