% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateClusteredNetwork.R
\name{generateClusteredNetwork}
\alias{generateClusteredNetwork}
\title{Function for generation of clustered networks}
\usage{
generateClusteredNetwork(n.cluster, n.points, n.dim = 2L,
  generator = lhs::maximinLHS, lower = 0, upper = 100, sigmas = NULL,
  n.depots = NULL, distribution.strategy = "equally.distributed",
  cluster.centers = NULL, out.of.bounds.handling = "mirror", name = NULL,
  ...)
}
\arguments{
\item{n.cluster}{[\code{integer(1)}]\cr
Desired number of clusters. This is ignored if \code{cluster.centers} is
provided.}

\item{n.points}{[\code{integer(1)}]\cr
Number of points for the network.}

\item{n.dim}{[\code{integer(1)}]\cr
Number of dimensions. Default ist 2.}

\item{generator}{[\code{function}]\cr
Function which generates cluster centers. Default is \code{\link[lhs]{maximinLHS}}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower box constaint for cube. Default is \code{0}.}

\item{upper}{[\code{numeric(1)}]\cr
Upper box constaint for cube. Default is \code{100}.}

\item{sigmas}{[\code{list} | \code{NULL}]\cr
Unnamed list of length \code{n.cluster} containing a covariance matrix
for each cluster. Default is \code{NULL}. In this case the covariance
matrix is a diagonal matrix containing the distances to the nearest neighbour
cluster center as diagonal elements.}

\item{n.depots}{[\code{integer(1)}]\cr
Number of depots in instances for the Vehicle Routing Problem (VRP).
Default is \code{NULL}, i. e., no depots. The proceeding is as follows:
If \code{n.depots} is \code{1L}, a random cluster center is defined to be the depot.
If \code{n.depots} is \code{2L}, the second depot has maximal distance to the first.
At the moment at most two depots are possible.}

\item{distribution.strategy}{[\code{character(1)}]\cr
Define the strategy to distribute \code{n.points} on the \code{n.cluster} clusters.
Default is \dQuote{equally.distributed}, which is the only option at the moment.}

\item{cluster.centers}{[\code{matrix}]\cr
Matrix of cluster centres of dimension \code{n.cluster} x \code{n.dim}. If
this is set, cluster centres are not generated automatically.
Default is \code{NULL}.}

\item{out.of.bounds.handling}{[\code{character(1)}]\cr
Clusters are generated on base of a multivariate gaussian distribution with
the cluster center as the mean vector. Possibly some of the points might fall
out of bounds, i. e., get coordinates larger than \code{upper} or lower than
\code{lower}. There are two strategies to force them to stick to the bounds:
\describe{
  \item{\dQuote{reset}}{Set the violating coordinates to the bounds.}
  \item{\dQuote{mirror}}{Mirror the coordinates at the violated axis.}
}
Default is \dQuote{mirror}.}

\item{name}{[\code{character(1)} | \code{NULL}]\cr
Optional name for the generated network. Default is \code{NULL}. In this case
a random name is generated.}

\item{...}{[\code{any}]\cr
Currently not used.}
}
\value{
[\code{ClusteredNetwork}]
  Object of type \code{ClusteredNetwork}.
}
\description{
This function generates clustered networks. It first generates \eqn{n} cluster
centeres via a latin hypercube design to ensure space-filling property, i. e.,
to ensure, that the clusters are placed far from each other.
It then distributes points to the clusters according to
gaussian distributions using the cluster centers as the mean vector and
the distance to the nearest neighbour cluster center as the variance.
This procedure works well if the box constraints of the hypercube are
not too low (see the lower bound for the \code{upper} parameter).
}
\examples{
x = generateClusteredNetwork(n.points = 20L, n.cluster = 2L)
y = generateClusteredNetwork(n.points = 40L, n.cluster = 3L, n.depots = 2L)
z = generateClusteredNetwork(n.points = 200L, n.cluster = 10L, out.of.bounds.handling = "reset")
}
\seealso{
\code{\link{generateRandomNetwork}}
}

