% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{as_dgCMatrix}
\alias{as_dgCMatrix}
\alias{as.dgCMatrix}
\alias{as_spmat}
\alias{as_dgCMatrix.default}
\alias{as_dgCMatrix.diffnet}
\alias{as_dgCMatrix.array}
\alias{as_dgCMatrix.igraph}
\alias{as_dgCMatrix.network}
\title{Coerce a matrix-like objects to \code{dgCMatrix} (sparse matrix)}
\usage{
as_dgCMatrix(x, ...)

as.dgCMatrix(x, ...)

as_spmat(x, ...)

\method{as_dgCMatrix}{default}(x, ...)

\method{as_dgCMatrix}{diffnet}(x, ...)

\method{as_dgCMatrix}{array}(x, ...)

\method{as_dgCMatrix}{igraph}(x, ...)

\method{as_dgCMatrix}{network}(x, ...)
}
\arguments{
\item{x}{An object to be coerced into a sparse matrix.}

\item{...}{Further arguments passed to the method.}
}
\value{
Either a list with \code{dgCMatrix} objects or a \code{dgCMatrix} object.
}
\description{
This helper function allows easy coercion to sparse matrix objects
from the \pkg{Matrix} package, \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}.
}
\details{
In the case of the \code{igraph} and \code{network} methods, \code{...} is passed to
\code{\link[igraph:as_adj]{as_adj}} and \code{\link[network:as.matrix.network]{as.matrix.network}}
respectively.
}
\examples{

set.seed(1231)
x <- rgraph_er(10)

# From matrix object
as_dgCMatrix(as.matrix(x))

# From a network object
as_dgCMatrix(network::as.network(as.matrix(x)))

# From igraph object
as_dgCMatrix(igraph::graph_from_adjacency_matrix(x))

# From array
myarray <- array(dim=c(10,10,2))
myarray[,,1] <- as.matrix(x)
myarray[,,2] <- as.matrix(x)

myarray
as_dgCMatrix(myarray)

# From a diffnet object
as_dgCMatrix(medInnovationsDiffNet)


}
