% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{\%*\%}
\alias{\%*\%}
\alias{\%*\%.default}
\alias{\%*\%.diffnet}
\title{Matrix multiplication}
\usage{
x \%*\% y

\method{\%*\%}{default}(x, y)

\method{\%*\%}{diffnet}(x, y)
}
\arguments{
\item{x}{Numeric or complex matrices or vectors, or \code{diffnet} objects.}

\item{y}{Numeric or complex matrices or vectors, or \code{diffnet} objects.}
}
\value{
In the case of \code{diffnet} objects performs matrix multiplication
via \code{\link{mapply}} using \code{x$graph} and \code{y$graph} as arguments,
returnling a \code{diffnet}. Otherwise returns the default according to
\code{\link[base:matmult]{\%*\%}}.
}
\description{
Matrix multiplication methods, including \code{\link{diffnet}}
objects. This function creates a generic method for \code{\link[base:matmult]{\%*\%}}
allowing for multiplying diffnet objects.
}
\details{
This function can be usefult to generate alternative graphs, for
example, users could compute the n-steps graph by doing \code{net \%*\% net}
(see examples).
}
\examples{
# Finding the Simmelian Ties network ----------------------------------------

# Random diffnet graph
set.seed(773)
net <- rdiffnet(100, 4, seed.graph='small-world', rgraph.args=list(k=8))
netsim <- net

# According to Dekker (2006), Simmelian ties can be computed as follows
netsim <- net * t(net) # Keeping mutal
netsim <- netsim * (netsim \%*\% netsim)

# Checking out differences (netsim should have less)
nlinks(net)
nlinks(netsim)

mapply(`-`, nlinks(net), nlinks(netsim))

}
\seealso{
Other diffnet methods: \code{\link{as.array.diffnet}},
  \code{\link{as_diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet_index}}
}

