% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_traj.R
\name{LQR}
\alias{LQR}
\title{Linear Quadratic Regulator}
\usage{
LQR(X, U, S, Q_seq, R_seq, eval = TRUE)
}
\arguments{
\item{X}{A \eqn{t x p} matrix of state values}

\item{U}{A \eqn{t-1 x q} matrix of control inputs`}

\item{S}{A \eqn{p x p} final state weighting matrix}

\item{Q_seq}{A list of \eqn{t} \eqn{p x p} intermediate state weighting matrices or a single \eqn{p x p} intermediate state weighting matrix}

\item{R_seq}{A list of \eqn{t} \eqn{q x q} intermediate cost matrices or a single \eqn{q x q} cost matrix}

\item{eval}{Boolean, if \code{FALSE} returns a function, if \code{TRUE} calculates the LQR series}
}
\value{
A function or a \eqn{t} length numeric vector
}
\description{
Creates a function that can be used to calculate the cumulative value of the LQR
 for any set of states and control inputs. By setting eval to True, 
 the LQR is immediately calculated. See \insertCite{lewisOptimalControl2012}{netcontrol}
 
NOTE: LQR functions, as they are calculated forward in time, go to 0 by the maximum time regardless of input. 
This is expected behavior, but that does make using the LQR value to evaluate control efficacy somewhat difficult.
}
\examples{

X = matrix(1, 100, 3)
U = matrix(-1, 99, 3)
S = Q_seq = R_seq = diag(3)

print(LQR(X,U, S, Q_seq, R_seq)[1:5])

}
\references{
\insertRef{lewisOptimalControl2012}{netcontrol}
}
