% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_NM.R
\name{grow_NM}
\alias{grow_NM}
\title{Grow a Niche Model Network}
\usage{
grow_NM(matrix, x, niches, connectance = 0.2, directed = TRUE, retcon = FALSE)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be grown.}

\item{niches}{Vector of length x, with values between zero and one corresponding to each node's niche.}

\item{connectance}{Niche Model parameter specifying the expected connectivity of the network, which determines for a given node the niche space window within which it attaches to every other node. Defaults to 0.2.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}

\item{retcon}{Binary variable determining if already existing nodes can attach to new nodes. Defaults to FALSE.}
}
\value{
An adjacency matrix.
}
\description{
Grows an already existing network by adding a node according to the Niche Model mechanism. Nodes can only attach to previously grown nodes.
}
\details{
Stirs a node in a Niche Model network.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- grow_NM(matrix = new_network_prep, x = size + 1, niches = stats::runif(size))

}
\references{
Williams, R. J., & Martinez, N. D. (2000). Simple rules yield complex food webs. Nature, 404(6774), 180-183.
}
