% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_pp.R
\name{nested_performance_profile}
\alias{nested_performance_profile}
\title{Nested performance profile function}
\usage{
nested_performance_profile(
  data,
  minimize = TRUE,
  logbase = 1,
  legend_title = "",
  best_rule = "winner",
  xlab = expression(tau),
  ylab = expression(rho),
  xmax = 0,
  colors = c(),
  plot = TRUE,
  xgrid = c()
)
}
\arguments{
\item{data}{data frame with the data}

\item{minimize}{true if lower values mean best performance and false otherwise}

\item{logbase}{base of the logarithm used to represent nested performance profiles}

\item{legend_title}{title for the legend}

\item{best_rule}{option to choose the best solver eliminated in each iteration ("winner", "mean", "gmean", "median" or custom function)}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{xmax}{maximum value of xaxis}

\item{colors}{vector with the colors of each configuration}

\item{plot}{bool to display the plot or not}

\item{xgrid}{vector for using it as grid in ratios}
}
\value{
ggplot object with the corresponding nested performance profile
}
\description{
Function that returns a ggplot object with the corresponding nested performance profile
}
\examples{
example_data = generate_random_example(seed = 1234)
nested_performance_profile(example_data)

}
