% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_nest.R
\name{step_nest}
\alias{step_nest}
\title{Nest transformation}
\usage{
step_nest(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  names = NULL,
  lookup_table = NULL,
  skip = FALSE,
  id = recipes::rand_id("nest")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{step_nest}, this indicates the variables which will \emph{not} be
nested. See \code{\link[recipes:selections]{recipes::selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{names}{The names of the variables selected by \code{...} are stored here
once this preprocessing step has been trained by \code{\link[recipes:prep]{recipes::prep()}}.}

\item{lookup_table}{The table describing which values of your selected
columns correspond to which 'nest_id' are stored here once this
preprocessing step has been trained by \code{\link[recipes:prep]{recipes::prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_nest()} creates a \emph{specification} of a recipe step that will
convert specified data into a single model term, specifying the 'nest'
that each row of the dataset corresponds to.
}
\details{
\code{step_nest()} will create a single nominal variable (named 'nest_id')
from a set of variables (of any type). Every unique combination
of the specified columns will receive a single nest id.

This recipe step is designed for use with nested models, since a model
will be fitted on the data corresponding to each nest id. Using a recipe
is often easier and more reliable than nesting the data manually.

The nest id corresponding to each unique combination of column values is
decided when the recipe is prepped (if this recipe is contained in a
workflow, this happens when the workflow is fitted). This means that
when using a prepped recipe on new data (using \code{\link[recipes:prep]{recipes::prep()}} or
\code{\link[workflows:predict-workflow]{workflows::predict.workflow()}}), all unique combinations of nesting
columns must also exist in the training data. You will be warned if
this is not the case. If you are using the 'rsample' package to create
splits and this presents an issue, you may want to consider using
\code{\link[=nested_resamples]{nested_resamples()}}.

\code{step_nest()} is designed so that nesting the transformed data by its
'nest_id' column is equivalent to the following action on the
non-transformed data:

\if{html}{\out{<div class="sourceCode">}}\preformatted{data \%>\%
  dplyr::group_by(...) \%>\% # '...' represents your specified terms
  tidyr::nest()
}\if{html}{\out{</div>}}
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned showing
how each unique value of the terms you have specified correspond to each
nest id.
}

\section{Case weights}{
The underlying operation does not allow for case weights.
}

\examples{
recipe <- recipes::recipe(example_nested_data, z ~ x + id) \%>\%
  step_nest(id)

recipe \%>\%
  recipes::prep() \%>\%
  recipes::bake(NULL)

recipe2 <- recipes::recipe(example_nested_data, z ~ x + id) \%>\%
  step_nest(-c(x, z))

recipe2 \%>\%
  recipes::prep() \%>\%
  recipes::bake(NULL)

}
