% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.nested_model_fit}
\alias{predict.nested_model_fit}
\alias{predict_raw.nested_model_fit}
\title{Nested Model Predictions}
\usage{
\method{predict}{nested_model_fit}(object, new_data, type = NULL, opts = list(), ...)

\method{predict_raw}{nested_model_fit}(object, new_data, opts = list(), ...)
}
\arguments{
\item{object}{A \code{nested_model_fit} object produced by
\code{\link[=fit.nested_model]{fit.nested_model()}}.}

\item{new_data}{A data frame to make predictions on. Can be nested or
non-nested.}

\item{type}{A singular character vector or \code{NULL}. Passed on to
\code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}}.}

\item{opts}{A list of optional arguments. Passed on to
\code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}}.}

\item{...}{Arguments for the underlying model's predict function. Passed on
to \code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}}.}
}
\value{
A data frame of model predictions. For \code{predict_raw()}, a
matrix, data frame, vector or list.
}
\description{
Apply a fitted nested model to generate different types of predictions.
\code{\link[stats:predict]{stats::predict()}} / \code{\link[parsnip:predict.model_fit]{parsnip::predict_raw()}} methods for nested model fits.
}
\examples{
data <- dplyr::filter(example_nested_data, id \%in\% 5:15)

nested_data <- tidyr::nest(data, data = -id)

model <- parsnip::linear_reg() \%>\%
  parsnip::set_engine("lm") \%>\%
  nested()

fitted <- fit(model, z ~ x + y + a + b, nested_data)

predict(fitted, example_nested_data)

parsnip::predict_raw(fitted, example_nested_data)

}
\seealso{
\code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}}
}
