% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_recall.R
\name{plot.prc}
\alias{plot.prc}
\title{Plot precision-recall curve}
\usage{
\method{plot}{prc}(x, ...)
}
\arguments{
\item{x}{An object of class 'prc'}

\item{...}{Optional graphical arguments passed to \code{\link[=plot]{plot()}}}
}
\value{
No return value
}
\description{
Plots a precision-recall curve using base graphics. It accepts an S3 object
of class 'prc', see \code{\link[=prc]{prc()}}.
}
\examples{
\donttest{
library(mlbench)
data(Sonar)
y <- Sonar$Class
x <- Sonar[, -61]

fit1 <- nestcv.glmnet(y, x, family = "binomial", alphaSet = 1, cv.cores = 2)
fit1$prc <- prc(fit1)  # calculate precision-recall curve

fit2 <- nestcv.train(y, x, method = "gbm", cv.cores = 2)
fit2$prc <- prc(fit2)

plot(fit1$prc)
lines(fit2$prc, col = "red")
}
}
\seealso{
\code{\link[=prc]{prc()}}
}
