% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{mcc}
\alias{mcc}
\alias{mcc_multi}
\title{Matthews correlation coefficient}
\usage{
mcc(cm)

mcc_multi(cm)
}
\arguments{
\item{cm}{A contingency table or matrix of predicted vs observed classes with
reference classes in columns and predicted classes in rows.}
}
\value{
Returns a value between -1 and +1. A coefficient of +1
represents a perfect prediction, 0 no better than random prediction and -1
indicates total disagreement between prediction and observation.
}
\description{
Calculates Matthews correlation coefficient (MCC) which is in essence a
correlation coefficient between the observed and predicted binary
classifications. It has also been generalised to multi-class classification.
}
\details{
Use \code{mcc()} for 2x2 tables (binary classification). \code{mcc_multi()} is
for multi-class classification with k x k tables and is calculated using
Gorodkin's method.
}
\references{
Gorodkin, J. (2004). \emph{Comparing two K-category assignments by a
K-category correlation coefficient}. Computational Biology and Chemistry. 28
(5): 367–374.
}
