% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{supervisedPCA}
\alias{supervisedPCA}
\title{Supervised PCA plot}
\usage{
supervisedPCA(y, x, filterFUN = NULL, filter_options = NULL, plot = TRUE, ...)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{filterFUN}{Filter function, e.g. \link{ttest_filter} or \link{relieff_filter}.
Any function can be provided and is passed \code{y} and \code{x}. Must return a
character vector with names of filtered predictors.}

\item{filter_options}{List of additional arguments passed to the filter
function specified by \code{filterFUN}.}

\item{plot}{Logical whether to plot a ggplot2 object or return the PC scores}

\item{...}{Optional arguments passed to \code{\link[=princomp]{princomp()}}}
}
\value{
If \code{plot=TRUE} returns a ggplot2 plot, otherwise returns the
principle component scores.
}
\description{
Performs supervised principle component analysis (PCA) after filtering
dataset to help determine whether filtering has been useful for separating
samples according to the outcome variable.
}
