% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smote.R
\name{smote}
\alias{smote}
\title{SMOTE}
\usage{
smote(y, x, k = 5, over = NULL, yminor = NULL)
}
\arguments{
\item{y}{Vector of response outcome as a factor}

\item{x}{Matrix of predictors}

\item{k}{Range of KNN to consider for generation of new data}

\item{over}{Amount of oversampling of the minority class. If set to \code{NULL}
then all classes will be oversampled up to the number of samples in the
majority class.}

\item{yminor}{Optional character value specifying the level in \code{y} which is
to be oversampled. If \code{NULL}, this is set automatically to the class with
the smallest sample size.}
}
\value{
List containing extended matrix \code{x} of synthesised data and extended
response vector \code{y}
}
\description{
Synthetic Minority Oversampling Technique (SMOTE) algorithm for imbalanced
classification data.
}
\references{
Chawla, N. V., Bowyer, K. W., Hall, L. O., and Kegelmeyer, W. P. (2002).
\emph{Smote: Synthetic minority over-sampling technique}. Journal of
Artificial Intelligence Research, 16:321-357.
}
