% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{wilcoxon_filter}
\alias{wilcoxon_filter}
\title{Wilcoxon test filter}
\usage{
wilcoxon_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  exact = FALSE,
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on Wilcoxon test. If 2 or more predictors are collinear, the first ranked
predictor by Wilcoxon test is retained, while the other collinear predictors are
removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a matrix of p-values.}

\item{exact}{Logical whether exact or approximate p-value is calculated.
Default is \code{FALSE} for speed.}

\item{...}{Further arguments passed to \link[matrixTests:wilcoxon]{matrixTests::row_wilcoxon_twosample}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} full output from \link[matrixTests:wilcoxon]{matrixTests::row_wilcoxon_twosample}
is returned.
}
\description{
Simple univariate filter using Wilcoxon (Mann-Whitney) test using the
matrixTests package.
}
