% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfObject.R
\name{attribute,ncdfObject-method}
\alias{attribute,ncdfObject-method}
\title{Get an attribute value}
\usage{
\S4method{attribute}{ncdfObject}(object, att)
}
\arguments{
\item{object}{A \code{ncdfObject} instance.}

\item{att}{Attribute to find in $name column.}
}
\value{
Value of the $value column or \code{character(0)} when not found.
}
\description{
Extract the value of a named attribute of the ncdfCF object. When found, the
value will have the type of the attribute and it may be of type list if the
attribute has multiple values.
}
\examples{
fn <- system.file("extdata",
                  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
                  package = "ncdfCF")
ds <- open_ncdf(fn)
lon <- ds[["lon"]]
attribute(lon, "standard_name")
}
