% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_internal.R
\name{internalGetCauseMetrics}
\alias{internalGetCauseMetrics}
\title{Calculate performance metrics table per cause}
\usage{
internalGetCauseMetrics(pred, obs, causes = unique(c(pred, obs)))
}
\arguments{
\item{pred}{Chracter vector of predicted causes for each case.}

\item{obs}{Character vector of observed causes for each case.}

\item{causes}{Character vector of all possible causes including ones that are not in the \emph{pred} or \emph{obs}.}
}
\value{
out Dataframe of a performance metrics per cause (see \href{https://rrwen.github.io/nbc4va/methods}{Methods documentation}):
\itemize{
  \item Columns: Cause, TruePositives, TrueNegatives, FalsePositives, FalseNegatives, PredictedFrequency, ObservedFrequency, Sensitivity, CSMFpredicted, CSMFobserved
  \item Cause (vectorof char): The unique causes from both the \emph{obs} and \emph{pred} inputs
  \item Sensitivity (vectorof double): the sensitivity for a cause
  \item CSMFpredicted (vectorof double): the cause specific mortality fraction for a cause given the predicted deaths
  \item CSMFobserved (vectorof double): the cause specific mortality fraction for a cause given the observed deaths
  \item TruePositives (vectorof double): The total number of true positives per cause
  \item TrueNegatives (vectorof double): The total number of true negatives per cause
  \item FalsePositives (vectorof double): The total number of false positives per cause
  \item FalseNegatives (vectorof double): The total number of false negatives per cause
  \item PredictedFrequency (vectorof double): The occurence of a cause in the \emph{pred} input
  \item ObservedFrequency (vectorof double): The occurence of a cause in the \emph{obs} input
}
Example:
\tabular{cccc}{
  Cause \tab Sensitivity \tab Metric-n.. \cr
  HIV \tab 0.5 \tab #.. \cr
  Stroke \tab 0.5 \tab #..
}
}
\description{
A table providing performance metrics per unique cause based on input predicted and observed cases.
}
\details{
This code is built on the original performance metrics code provided by Dr. Mireille Gomes.
}
\examples{
library(nbc4va)
pred <- c("HIV", "Stroke", "HIV", "Stroke")
obs <- c("HIV", "HIV", "Stroke", "Stroke")
cmetrics <- nbc4va:::internalGetCauseMetrics(pred, obs)

}
\seealso{
Other internal functions: \code{\link{internalGetCSMFAcc}},
  \code{\link{internalGetCSMFMaxError}},
  \code{\link{internalGetMetrics}},
  \code{\link{internalNBC}}
}
\keyword{internal}
