% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{ntwd_get}
\alias{ntwd_get}
\title{Download House Price Data from Nationwide}
\usage{
ntwd_get(id, verbose = TRUE)
}
\arguments{
\item{id}{which `id`to fetch. See `?ntwd_dataset` for a full list.}

\item{verbose}{whether to print the url of the data.}
}
\value{
Returns a tibble.
}
\description{
This function scrapes Nationwide's House Price Index webpage and
downloads data in tidy format. Available datasets are given an `id`. All
available `id` and short descriptions  can be viewed via `?datasets`.
For more information the user can browse the source webpage through
\code{\link{ntwd_browse}}.
}
\examples{
\donttest{
ntwd_get("monthly")

ntwd_get("terraced")

# For a list of datasets
?ntwd_datasets
}
}
